% Script3DTimeDispersion

% Configuration parameters for the model we are going to simulate
% Shows the model we are going to simulate on this script

clear

% open sprottbxilinx.mdl
% open Script3DTimeDispersion.m

latenciamultiplier = 5;
binpoint = 44;
startime = 0;
stepsize = 0.01;

StopTime = [0.5:0.1:0.7 2:1:9 10:10:50 100:50:300 400:100:700 1000:300:2000];
MaxStopTime = max([ max(StopTime) 300]);
NumStopTime = size(StopTime,2);

Exponent = [30]; % Minimum value of Exponent equals to 4
discretisation = power(2,-Exponent);
NumDiscretisationCriteria = size(discretisation,2);

PercentageProgress = 2;

XMin = -9; XMax = 9; YMin = -6; YMax = 6; ZMin = -20; ZMax = 10;

NumX = 8; % Maximum value equals to 10;
NumY = 8; % Maximum value equals to 10;
NumZ = 8; % Maximum value equals to 10;

TimeStart = datevec(now); % Its is a 6x1 vector containing:  [Year Month Day Hour Minute Second]
copyfile('Script3DTimeDispersion.m',['', DATESTR(datenum(TimeStart),30), '_Script3DTimeDispersion.m']);
eval(['mkdir ', DATESTR(datenum(TimeStart),30), '_Figures']);
eval(['cd ', DATESTR(datenum(TimeStart),30), '_Figures']);
    eval(['mkdir ', DATESTR(datenum(TimeStart),30), '_Figures_3D']);
    eval(['mkdir ', DATESTR(datenum(TimeStart),30), '_Figures_2D_XY']);
    eval(['mkdir ', DATESTR(datenum(TimeStart),30), '_Figures_2D_XY_Zoom']);
    eval(['mkdir ', DATESTR(datenum(TimeStart),30), '_Figures_2D_XZ']);
    eval(['mkdir ', DATESTR(datenum(TimeStart),30), '_Figures_2D_YZ']);
cd ..

stoptime = 800;
zzero = 0.001;
yzero = 0.001;
xzero = 0.001;
sim('sprottbxilinx.mdl');
XWaterMark = xoutx;
YWaterMark = youtx;
ZWaterMark = zoutx;

LengthSim100W = length(XWaterMark); 
LengthSim50W = round(0.5*LengthSim100W);

LimHistXInf = 0.60 * (min ( [ min( XWaterMark(LengthSim50W:LengthSim100W) ) ]) );
LimHistXSup = 0.60 * (max ( [ max( XWaterMark(LengthSim50W:LengthSim100W) ) ]) );
LimHistYInf = 0.60 * (min ( [ min( YWaterMark(LengthSim50W:LengthSim100W) ) ]) );
LimHistYSup = 0.60 * (max ( [ max( YWaterMark(LengthSim50W:LengthSim100W) ) ]) );
LimHistZInf = 0.60 * (min ( [ min( ZWaterMark(LengthSim50W:LengthSim100W) ) ]) );
LimHistZSup = 0.60 * (max ( [ max( ZWaterMark(LengthSim50W:LengthSim100W) ) ]) );

BinHistX = ((LimHistXSup - LimHistXInf)/10);
BinHistY = ((LimHistYSup - LimHistYInf)/10);
BinHistZ = ((LimHistZSup - LimHistZInf)/10);

InitionConditionProblems = ones(1,9); % 9 Columns: xzero, yzero, zzero, divergent, convergent, saturated, lyapunov, Max Lyap Exp, One or more event together
InitionConditionProblems = 987654321*InitionConditionProblems;
InitionConditionNotProblems = ones(1,3); % 3 Columns: xzero, yzero, zzero
InitionConditionNotProblems = 987654321*InitionConditionNotProblems;
ICPpointer =  1;
ICNPpointer = 1;

InitionConditionProblemsAddendum = ones(1,10); % 7 Columns: 1) green or red (-1 or +1), 2) xoutx, 3) youtx, 4) zoutx, 5) Distance between IC and Final States (xoutx,youtx,zoutx), 6) stoptime, 7) DiscretisationCriteria, 8) xzero, 9) yzero, 10) zzero
InitionConditionProblemsAddendum = 987654321*InitionConditionProblemsAddendum;
InitionConditionNotProblemsAddendum = ones(1,10); % 7 Columns: 1) green or red (-1 or +1), 2) xoutx, 3) youtx, 4) zoutx, 5) Distance between IC and Final States (xoutx,youtx,zoutx), 6) stoptime, 7) DiscretisationCriteria, 8) xzero, 9) yzero, 10) zzero
InitionConditionNotProblemsAddendum = 987654321*InitionConditionNotProblemsAddendum;
ICPApointer =  1;
ICNPApointer = 1;

IterationsVersusSTDVol = ones(1,22); % 22 columns: 
IterationsVersusSTDVol = 987654321 * IterationsVersusSTDVol;
IterationsVersusSTDVolPointer = 1;
% 01) stoptime 02) DiscretisationCriteria 03) Exponent 04) MEAN_D 05) STD_D 06) MEAN_X  07) STD_X 08) MEAN_Y 09) STD_Y 10) MEAN_Z 11) STD_Z 12) STD_V
% 13) MEAN HIST_X 14) MIN HIST_X 15) MAX HIST_X 16) MEAN HIST_Y 17) MIN HIST_Y 18) MAX HIST_Y 19) MEAN HIST_Z 20) MIN HIST_Z 21) MAX HIST_Z 22) MIN/MAX HIST XYZ

MaxXoutxDiv = 850.00;  MinXoutxDiv = -850.00; MaxYoutxDiv = 850.00;  MinYoutxDiv = -850.00; MaxZoutxDiv = 850.00;  MinZoutxDiv = -850.00;
Conv_X_Threshold = 0.001; Conv_Y_Threshold = 0.001; Conv_Z_Threshold = 0.001;

% The number of Simulations is equal to the product of the number of xzero, yzero, zzero, stoptime and DiscretisationCriteria used
NumXZero = NumX + 1;
NumYZero = NumY + 1;
NumZZero = NumZ + 1;
NumberSimulationsTotal = NumXZero * NumYZero * NumZZero * NumStopTime * NumDiscretisationCriteria;
NumberSimulationsLeft = NumberSimulationsTotal; % Before starting the simulation, the NumberSimulationsLeft is equal to the  NumberSimulationsTotal

Second = 1/86400; % This express one second in terms of a day (one day has 24*60*60 = 86400 seconds)
Speed = 3500/324; % point per minute
TotalTimeForecast = NumberSimulationsTotal/Speed; % minutes
TimeEndForecast = datestr(datenum(TimeStart) + TotalTimeForecast*60*Second);
fprintf(1,'The simulation will end at: %s \n', TimeEndForecast);

for DiscretisationCriteria = discretisation
    
% We will have to define this variables again for the simulation (we define again just the variables that depend on Discratisation Criteria)
XZeroStart = XMin + rand(1)*( XMax - 10 * power(2,-4) - XMin);        XZeroStep =  DiscretisationCriteria;          XZeroEnd = XZeroStart + NumX * DiscretisationCriteria;
YZeroStart = YMin + rand(1)*( YMax - 10 * power(2,-4) - YMin);        YZeroStep =  DiscretisationCriteria;          YZeroEnd = YZeroStart + NumY * DiscretisationCriteria;
ZZeroStart = ZMin + rand(1)*( ZMax - 10 * power(2,-4) - ZMin);        ZZeroStep =  DiscretisationCriteria;          ZZeroEnd = ZZeroStart + NumZ * DiscretisationCriteria;
    
        % Inition Condiction CI 06A
        for zzero = ZZeroStart : ZZeroStep : ZZeroEnd;
            for yzero = YZeroStart : YZeroStep : YZeroEnd;
                for xzero = XZeroStart : XZeroStep : XZeroEnd;
                    
                    SimStart = now;
                    stoptime = MaxStopTime;
                    sim('sprottbxilinx.mdl');
                    
                    LengthSim100 = length(xoutx); LengthSim90 = round(0.9*LengthSim100);
                    Divergent = (max(xoutx(LengthSim90:LengthSim100)) > MaxXoutxDiv | min(xoutx(LengthSim90:LengthSim100)) < MinXoutxDiv | max(youtx(LengthSim90:LengthSim100)) > MaxYoutxDiv | min(youtx(LengthSim90:LengthSim100)) < MinYoutxDiv | max(zoutx(LengthSim90:LengthSim100)) > MaxZoutxDiv | min(zoutx(LengthSim90:LengthSim100)) < MinZoutxDiv);
                    Convergent = mean(abs(diff(xoutx(LengthSim90:LengthSim100)))) < Conv_X_Threshold | mean(abs(diff(youtx(LengthSim90:LengthSim100)))) < Conv_Y_Threshold | mean(abs(diff(zoutx(LengthSim90:LengthSim100)))) < Conv_Z_Threshold;
%                     Saturated = (length(find(xoutxsat ~= 0)) ~= 0 | length(find(youtxsat ~= 0)) ~= 0 | length(find(zoutxsat ~= 0)) ~= 0);

                    if Divergent == 1 | Convergent == 1 %| Saturated == 1
                        
                        if Divergent
                            InitionConditionProblems(ICPpointer,4) = 1;
                            InitionConditionProblems(ICPpointer,5) = 0;
                            InitionConditionProblems(ICPpointer,6) = 0;
                            InitionConditionProblems(ICPpointer,9) = 0;
                            if Convergent
                                InitionConditionProblems(ICPpointer,5) = 1;
                                InitionConditionProblems(ICPpointer,9) = 1;
                            end
%                             if Saturated
%                                 InitionConditionProblems(ICPpointer,6) = 1;
%                                 InitionConditionProblems(ICPpointer,9) = 1;
%                             end
                        end % if Divergent
		
                        if Divergent == 0 & Convergent == 1
                            InitionConditionProblems(ICPpointer,4) = 0;
                            InitionConditionProblems(ICPpointer,5) = 1;
                            InitionConditionProblems(ICPpointer,6) = 0;
                            InitionConditionProblems(ICPpointer,9) = 0;
%                             if Saturated
%                                 InitionConditionProblems(ICPpointer,6) = 1;
%                                 InitionConditionProblems(ICPpointer,9) = 1;
%                             end
                        end % if Divergent == 0 & Convergent == 1
		
                        if Divergent == 0 & Convergent == 0 %& Saturated == 1
                            InitionConditionProblems(ICPpointer,4) = 0;
                            InitionConditionProblems(ICPpointer,5) = 0;
                            InitionConditionProblems(ICPpointer,6) = 1;
                            InitionConditionProblems(ICPpointer,9) = 0;
                        end % if Divergent == 0 & Convergent == 0 & Saturated == 1

                        InitionConditionProblems(ICPpointer,1) = xzero;
                        InitionConditionProblems(ICPpointer,2) = yzero;
                        InitionConditionProblems(ICPpointer,3) = zzero;

                        % First we save on the appropriete table the values for future analysis
                        if InitionConditionProblems(1,1) ~= 987654321
                            eval(['InitionConditionProblems_', DATESTR(datenum(TimeStart),30), ' = InitionConditionProblems;']);
                            filename = (['', DATESTR(datenum(TimeStart),30), '_InitionConditionProblems.mat']);
                            eval(['save(filename,''InitionConditionProblems_', DATESTR(datenum(TimeStart),30), '*'')']);
                        end
                        % Second we plot the problematic Non-Chotic Attractor
                        figure(5)
                        plot( xoutx, youtx, 'r');
                        grid on; hold on;
						title(['Non-Chaotic Atractor (D', num2str(Divergent), ' C', num2str(Convergent), ') for xzero = ', num2str(xzero), ', yzero = ', num2str(yzero) ', zzero = ', num2str(zzero), '.']);
						xlabel(['Variable XOUTS']);
						ylabel(['Variable YOUTS']);
                        % Now we are going to save the non-chaotic attractor in the root diretory
						filename = ([DATESTR(datenum(TimeStart),30), '_Non_Chaotic_Attractor_', num2str(ICPpointer), '.jpg']);
						saveas(5, filename, 'jpg');
                        pause(1); beep; pause(1); beep; pause(1); beep;
                        close(5)
                        
                        ICPpointer = ICPpointer + 1; % Observe that all pointers are updated togheter. So, in the analysis process you can find by the appropriete index all data you will need.
                    
                    end % if Divergent == 1 | Convergent == 1 | Saturated == 1

                    if Divergent == 0 & Convergent == 0 %& Saturated == 0
                        
                        InitionConditionNotProblems(ICNPpointer,1) = xzero;
                        InitionConditionNotProblems(ICNPpointer,2) = yzero;
                        InitionConditionNotProblems(ICNPpointer,3) = zzero;
                            
                        ICNPpointer = ICNPpointer + 1; % Repensar pois havera buracos preenchidos com 9999 ou 8888 nas tabelas...

                    end % Divergent == 0 & Convergent == 0 & Saturated == 0
                    
                    for stoptime = StopTime;
                        
                        if Divergent == 1 | Convergent == 1 %| Saturated == 1
                            InitionConditionProblemsAddendum(ICPApointer,1) = 1;
                            % Now we save the final internal state on the columns of the table
                            InitionConditionProblemsAddendum(ICPApointer,2) = xoutx(round(stoptime/(latenciamultiplier*stepsize)-2));
                            InitionConditionProblemsAddendum(ICPApointer,3) = youtx(round(stoptime/(latenciamultiplier*stepsize)-2));
                            InitionConditionProblemsAddendum(ICPApointer,4) = zoutx(round(stoptime/(latenciamultiplier*stepsize)-2));
                            % Now we calculate the distance between IC and Final State
%                             InitionConditionProblemsAddendum(ICPApointer,5) = sqrt(...
%                             power(  (xzero - InitionConditionProblemsAddendum(ICPApointer,2)  ),  2)  + ...
%                             power(  (yzero - InitionConditionProblemsAddendum(ICPApointer,3)  ),  2)  + ...
%                             power(  (zzero - InitionConditionProblemsAddendum(ICPApointer,4)  ),  2)  );
                            % Now we save the StopTime and DiscretisationCriteria on the table
                            InitionConditionProblemsAddendum(ICPApointer,6) = stoptime;
                            InitionConditionProblemsAddendum(ICPApointer,7) = DiscretisationCriteria;
                            % Now we save the IC on the last columns of the table
                            InitionConditionProblemsAddendum(ICPApointer,8) = xzero;
                            InitionConditionProblemsAddendum(ICPApointer,9) = yzero;
                            InitionConditionProblemsAddendum(ICPApointer,10) = zzero;
                            % First we save on the appropriete table the values for future analysis
                            if InitionConditionProblemsAddendum(1,1) ~= 987654321
                                eval(['InitionConditionProblemsAddendum_', DATESTR(datenum(TimeStart),30), ' = InitionConditionProblemsAddendum;']);
                                filename = (['', DATESTR(datenum(TimeStart),30), '_InitionConditionProblemsAddendum.mat']);
                                eval(['save(filename,''InitionConditionProblemsAddendum_', DATESTR(datenum(TimeStart),30), '*'')']);
                            end
                            ICPApointer = ICPApointer + 1;
                        end % if Divergent == 1 | Convergent == 1 | Saturated == 1

                        if Divergent == 0 & Convergent == 0 %& Saturated == 0
                            
                            InitionConditionNotProblemsAddendum(ICNPApointer,1) = -1;
                            % Now we save the final internal state on the columns of the table
                            InitionConditionNotProblemsAddendum(ICNPApointer,2) = xoutx(round(stoptime/(latenciamultiplier*stepsize)-2));
                            InitionConditionNotProblemsAddendum(ICNPApointer,3) = youtx(round(stoptime/(latenciamultiplier*stepsize)-2));
                            InitionConditionNotProblemsAddendum(ICNPApointer,4) = zoutx(round(stoptime/(latenciamultiplier*stepsize)-2));
                            % Now we calculate the distance between IC and Final State
%                             InitionConditionNotProblemsAddendum(ICNPApointer,5) = sqrt(...
%                             power(  (xzero - InitionConditionNotProblemsAddendum(ICNPApointer,2)  ),  2)  + ...
%                             power(  (yzero - InitionConditionNotProblemsAddendum(ICNPApointer,3)  ),  2)  + ...
%                             power(  (zzero - InitionConditionNotProblemsAddendum(ICNPApointer,4)  ),  2)  );
                            % Now we save the StopTime on the last column of the table
                            InitionConditionNotProblemsAddendum(ICNPApointer,6) = stoptime;
                            InitionConditionNotProblemsAddendum(ICNPApointer,7) = DiscretisationCriteria;
                            % Now we save the IC on the last columns of the table
                            InitionConditionNotProblemsAddendum(ICNPApointer,8) = xzero;
                            InitionConditionNotProblemsAddendum(ICNPApointer,9) = yzero;
                            InitionConditionNotProblemsAddendum(ICNPApointer,10) = zzero;
                            ICNPApointer = ICNPApointer + 1;
    
                        end % Divergent == 0 & Convergent == 0 & Saturated == 0
                            
                        NumberSimulationsLeft = NumberSimulationsLeft - 1;
                        % Calculation of End of Simulation Time    
                        TimeActual = datevec(now); % Its is a 6x1 vector containing:  [Year Month Day Hour Minute Second]
                        TimeElapsed = datenum(TimeActual) - datenum(TimeStart); % Time is numerical form in reference to 01JAN0000
                        TimeEnd = datenum(TimeActual) + (TimeElapsed/(NumberSimulationsTotal-NumberSimulationsLeft))*(NumberSimulationsLeft);
                        Percentage = 100*(NumberSimulationsTotal-NumberSimulationsLeft)/(NumberSimulationsTotal);
                        if Percentage > PercentageProgress
                            fprintf(1,'%2.0f%% done. Starts: %s. Now: %s. End: %s \n', Percentage, datestr(TimeStart), datestr(now), datestr(TimeEnd))
                            PercentageProgress = PercentageProgress + 5;
                        end % if Percentage > PercentageProgress
	
                    end %for stoptime = StopTime;
                    
                end % for xzero = XZeroStart : XZeroStep : XZeroEnd;
            end % for yzero = YZeroStart : YZeroStep : YZeroEnd;
            
        % Now that we finished simulating all Initial Condictions, we can save the table of GOOD and BAD ICs
        if InitionConditionNotProblems(1,1) ~= 987654321
            eval(['InitionConditionNotProblems_', DATESTR(datenum(TimeStart),30), ' = InitionConditionNotProblems;']);
            filename = (['', DATESTR(datenum(TimeStart),30), '_InitionConditionNotProblems.mat']);
            eval(['save(filename,''InitionConditionNotProblems_', DATESTR(datenum(TimeStart),30), '*'')']);
        end
        if InitionConditionNotProblemsAddendum(1,1) ~= 987654321
            eval(['InitionConditionNotProblemsAddendum_', DATESTR(datenum(TimeStart),30), ' = InitionConditionNotProblemsAddendum;']);
            filename = (['', DATESTR(datenum(TimeStart),30), '_InitionConditionNotProblemsAddendum.mat']);
            eval(['save(filename,''InitionConditionNotProblemsAddendum_', DATESTR(datenum(TimeStart),30), '*'')']);
        end
            
        end % for zzero = ZZeroStart : ZZeroStep : ZZeroEnd;
	
end % for DiscretisationCriteria = discretisation

Aaa = min ( [ min( InitionConditionNotProblemsAddendum(:,8) ) , min( InitionConditionNotProblemsAddendum(:,2) ) , min( XWaterMark ) ]) - 5;
Bbb = max ( [ max( InitionConditionNotProblemsAddendum(:,8) ) , max( InitionConditionNotProblemsAddendum(:,2) ) , max( XWaterMark ) ]) + 5;
Ccc = min ( [ min( InitionConditionNotProblemsAddendum(:,9) ) , min( InitionConditionNotProblemsAddendum(:,3) ) , min( YWaterMark ) ]) - 5;
Ddd = max ( [ max( InitionConditionNotProblemsAddendum(:,9) ) , max( InitionConditionNotProblemsAddendum(:,3) ) , max( YWaterMark ) ]) + 5;
Eee = min ( [ min( InitionConditionNotProblemsAddendum(:,10) ) , min( InitionConditionNotProblemsAddendum(:,4) ) , min( ZWaterMark ) ]) - 5;
Fff = max ( [ max( InitionConditionNotProblemsAddendum(:,10) ) , max( InitionConditionNotProblemsAddendum(:,4) ) , max( ZWaterMark ) ]) + 5;

for DiscretisationCriteria = discretisation
    for stoptime = StopTime;

        cade = find(InitionConditionNotProblemsAddendum(:,6) == stoptime & InitionConditionNotProblemsAddendum(:,7) == DiscretisationCriteria);
        StdVol = std(InitionConditionNotProblemsAddendum(cade,2)) * std(InitionConditionNotProblemsAddendum(cade,3)) * std(InitionConditionNotProblemsAddendum(cade,4));
        HistVol = (min(hist(InitionConditionNotProblemsAddendum(cade,2) , [-3 : 0.6 : 3])) / mean(hist(InitionConditionNotProblemsAddendum(cade,2) , [-3 : 0.6 : 3]))) * ...
                  (min(hist(InitionConditionNotProblemsAddendum(cade,3) , [-2 : 0.4 : 2])) / mean(hist(InitionConditionNotProblemsAddendum(cade,3) , [-2 : 0.4 : 2]))) * ... 
                  (min(hist(InitionConditionNotProblemsAddendum(cade,4) , [-2 : 0.4 : 2])) / mean(hist(InitionConditionNotProblemsAddendum(cade,4) , [-2 : 0.4 : 2])));
        
        figure(8)
        plot3(XWaterMark,YWaterMark,ZWaterMark,'y'); hold on; grid on;
        plot3(InitionConditionNotProblemsAddendum(cade,8),InitionConditionNotProblemsAddendum(cade,9),InitionConditionNotProblemsAddendum(cade,10),'g.');
        plot3(InitionConditionNotProblemsAddendum(cade,2),InitionConditionNotProblemsAddendum(cade,3),InitionConditionNotProblemsAddendum(cade,4),'c.');
		title(['3D Dispersion for: Iteration = ', num2str(stoptime), ' (', num2str(min(StopTime)), ':', num2str(max(StopTime)), '), Exponent = ', num2str(-log2(DiscretisationCriteria)), ' (', num2str(min(Exponent)), ':', num2str(max(Exponent)), '), Std _V_o_l = ', num2str( StdVol ), ', Hist _V_o_l Min/Max = ', num2str( HistVol )]);
		xlabel(['Chaotic XOUTS output for Xo = ', num2str(XZeroStart), ' : ', num2str(-log2(XZeroStep)), ' : ', num2str(XZeroEnd),  ' , Yo = ', num2str(YZeroStart), ' : ', num2str(-log2(YZeroStep)), ' : ', num2str(YZeroEnd), ' , Zo = ', num2str(ZZeroStart), ' : ', num2str(-log2(ZZeroStep)), ' : ', num2str(ZZeroEnd)]);
		ylabel(['Chaotic YOUTS output']);
        zlabel(['Chaotic ZOUTS output']);
        AXIS([Aaa Bbb Ccc Ddd Eee Fff]);        
        % Now we are going to save the produced grafic in 2 different formats
		eval(['cd ', DATESTR(datenum(TimeStart),30), '_Figures']);
        eval(['cd ', DATESTR(datenum(TimeStart),30), '_Figures_3D']);
		filename = ([DATESTR(datenum(now),30), '_Dispersion_3D_', num2str(-log2(DiscretisationCriteria)), '_EXP_', num2str(stoptime), '_StopTime', '.fig']);
		saveas(8, filename, 'fig');
		filename = ([DATESTR(datenum(now),30), '_Dispersion_3D_', num2str(-log2(DiscretisationCriteria)), '_EXP_', num2str(stoptime), '_StopTime', '.jpg']);
		saveas(8, filename, 'jpg');
		cd .. ; cd .. ;
		close(8);

        figure(8)
        plot(XWaterMark,YWaterMark,'y'); hold on; grid on;
        plot(InitionConditionNotProblemsAddendum(cade,8),InitionConditionNotProblemsAddendum(cade,9),'g.');
        plot(InitionConditionNotProblemsAddendum(cade,2),InitionConditionNotProblemsAddendum(cade,3),'c.');
		title(['2D Dispersion for: Iteration = ', num2str(stoptime), ' (', num2str(min(StopTime)), ':', num2str(max(StopTime)), '), Exponent = ', num2str(-log2(DiscretisationCriteria)), ' (', num2str(min(Exponent)), ':', num2str(max(Exponent)), '), Std _V_o_l = ', num2str( StdVol ), ', Hist _V_o_l Min/Max = ', num2str( HistVol )]);
		xlabel(['Chaotic XOUTS output for Xo = ', num2str(XZeroStart), ' : ', num2str(-log2(XZeroStep)), ' : ', num2str(XZeroEnd),  ' , Yo = ', num2str(YZeroStart), ' : ', num2str(-log2(YZeroStep)), ' : ', num2str(YZeroEnd), ' , Zo = ', num2str(ZZeroStart), ' : ', num2str(-log2(ZZeroStep)), ' : ', num2str(ZZeroEnd),')']);
		ylabel(['Chaotic YOUTS output']);
        AXIS([Aaa Bbb Ccc Ddd]);        
		% Now we are going to save the produced grafic in 2 different formats
		eval(['cd ', DATESTR(datenum(TimeStart),30), '_Figures']);
        eval(['cd ', DATESTR(datenum(TimeStart),30), '_Figures_2D_XY']);
		filename = ([DATESTR(datenum(now),30), '_Dispersion_3D_XY_', num2str(-log2(DiscretisationCriteria)), '_EXP_', num2str(stoptime), '_StopTime', '.fig']);
		saveas(8, filename, 'fig');
		filename = ([DATESTR(datenum(now),30), '_Dispersion_3D_XY_', num2str(-log2(DiscretisationCriteria)), '_EXP_', num2str(stoptime), '_StopTime', '.jpg']);
		saveas(8, filename, 'jpg');
		cd .. ; 
        AXIS([Aaa+5 Bbb-5 Ccc+5 Ddd-5]);
        eval(['cd ', DATESTR(datenum(TimeStart),30), '_Figures_2D_XY_Zoom']);
		filename = ([DATESTR(datenum(now),30), '_Dispersion_3D_XY_Zoom_', num2str(-log2(DiscretisationCriteria)), '_EXP_', num2str(stoptime), '_StopTime', '.fig']);
		saveas(8, filename, 'fig');
		filename = ([DATESTR(datenum(now),30), '_Dispersion_3D_XY_Zoom_', num2str(-log2(DiscretisationCriteria)), '_EXP_', num2str(stoptime), '_StopTime', '.jpg']);
		saveas(8, filename, 'jpg');
		cd .. ; cd .. ;
		close(8);
        
        figure(8)
        plot(XWaterMark,ZWaterMark,'y'); hold on; grid on;
        plot(InitionConditionNotProblemsAddendum(cade,8),InitionConditionNotProblemsAddendum(cade,10),'g.');
        plot(InitionConditionNotProblemsAddendum(cade,2),InitionConditionNotProblemsAddendum(cade,4),'c.');
		title(['2D Dispersion for: Iteration = ', num2str(stoptime), ' (', num2str(min(StopTime)), ':', num2str(max(StopTime)), '), Exponent = ', num2str(-log2(DiscretisationCriteria)), ' (', num2str(min(Exponent)), ':', num2str(max(Exponent)), '), Std _V_o_l = ', num2str( StdVol ), ', Hist _V_o_l Min/Max = ', num2str( HistVol )]);
		xlabel(['Chaotic XOUTS output for Xo = ', num2str(XZeroStart), ' : ', num2str(-log2(XZeroStep)), ' : ', num2str(XZeroEnd),  ' , Yo = ', num2str(YZeroStart), ' : ', num2str(-log2(YZeroStep)), ' : ', num2str(YZeroEnd), ' , Zo = ', num2str(ZZeroStart), ' : ', num2str(-log2(ZZeroStep)), ' : ', num2str(ZZeroEnd),')']);
        zlabel(['Chaotic ZOUTS output']);
        AXIS([Aaa Bbb Eee Fff]);        
		% Now we are going to save the produced grafic in 2 different formats
		eval(['cd ', DATESTR(datenum(TimeStart),30), '_Figures']);
        eval(['cd ', DATESTR(datenum(TimeStart),30), '_Figures_2D_XZ']);
		filename = ([DATESTR(datenum(now),30), '_Dispersion_2D_XZ_', num2str(-log2(DiscretisationCriteria)), '_EXP_', num2str(stoptime), '_StopTime', '.fig']);
		saveas(8, filename, 'fig');
		filename = ([DATESTR(datenum(now),30), '_Dispersion_2D_XZ_', num2str(-log2(DiscretisationCriteria)), '_EXP_', num2str(stoptime), '_StopTime', '.jpg']);
		saveas(8, filename, 'jpg');
		cd .. ; cd .. ;
		close(8);
        
        figure(8)
        plot(YWaterMark,ZWaterMark,'y'); hold on; grid on;
        plot(InitionConditionNotProblemsAddendum(cade,9),InitionConditionNotProblemsAddendum(cade,10),'g.');
        plot(InitionConditionNotProblemsAddendum(cade,3),InitionConditionNotProblemsAddendum(cade,4),'c.');
		title(['2D Dispersion for: Iteration = ', num2str(stoptime), ' (', num2str(min(StopTime)), ':', num2str(max(StopTime)), '), Exponent = ', num2str(-log2(DiscretisationCriteria)), ' (', num2str(min(Exponent)), ':', num2str(max(Exponent)), '), Std _V_o_l = ', num2str( StdVol ), ', Hist _V_o_l Min/Max = ', num2str( HistVol )]);
		ylabel(['Chaotic YOUTS output for Xo = ', num2str(XZeroStart), ' : ', num2str(-log2(XZeroStep)), ' : ', num2str(XZeroEnd),  ' , Yo = ', num2str(YZeroStart), ' : ', num2str(-log2(YZeroStep)), ' : ', num2str(YZeroEnd), ' , Zo = ', num2str(ZZeroStart), ' : ', num2str(-log2(ZZeroStep)), ' : ', num2str(ZZeroEnd),')']);
        zlabel(['Chaotic ZOUTS output']);
        AXIS([Ccc Ddd Eee Fff]);        
		% Now we are going to save the produced grafic in 2 different formats
		eval(['cd ', DATESTR(datenum(TimeStart),30), '_Figures']);
        eval(['cd ', DATESTR(datenum(TimeStart),30), '_Figures_2D_YZ']);
		filename = ([DATESTR(datenum(now),30), '_Dispersion_2D_YZ_', num2str(-log2(DiscretisationCriteria)), '_EXP_', num2str(stoptime), '_StopTime', '.fig']);
		saveas(8, filename, 'fig');
		filename = ([DATESTR(datenum(now),30), '_Dispersion_2D_YZ_', num2str(-log2(DiscretisationCriteria)), '_EXP_', num2str(stoptime), '_StopTime', '.jpg']);
		saveas(8, filename, 'jpg');
		cd .. ; cd .. ;
		close(8);

        % IterationsVersusSTDVol = ones(1,22); % 22 columns: % 01) stoptime 02) DiscretisationCriteria 03) Exponent 04) MEAN_D 05) STD_D 06) MEAN_X  07) STD_X 08) MEAN_Y 09) STD_Y 10) MEAN_Z 11) STD_Z 12) STD_V
        % % 13) MEAN HIST_X 14) MIN HIST_X 15) MAX HIST_X 16) MEAN HIST_Y 17) MIN HIST_Y 18) MAX HIST_Y 19) MEAN HIST_Z 20) MIN HIST_Z 21) MAX HIST_Z 22) MIN/MAX HIST XYZ

		IterationsVersusSTDVol(IterationsVersusSTDVolPointer,1) = stoptime;
		IterationsVersusSTDVol(IterationsVersusSTDVolPointer,2) = DiscretisationCriteria;
		IterationsVersusSTDVol(IterationsVersusSTDVolPointer,3) = log2(DiscretisationCriteria);
		IterationsVersusSTDVol(IterationsVersusSTDVolPointer,4) = mean(InitionConditionNotProblemsAddendum(cade,5));
		IterationsVersusSTDVol(IterationsVersusSTDVolPointer,5) = std(InitionConditionNotProblemsAddendum(cade,5));
		IterationsVersusSTDVol(IterationsVersusSTDVolPointer,6) = mean(InitionConditionNotProblemsAddendum(cade,2));
		IterationsVersusSTDVol(IterationsVersusSTDVolPointer,7) = std(InitionConditionNotProblemsAddendum(cade,2));
		IterationsVersusSTDVol(IterationsVersusSTDVolPointer,8) = mean(InitionConditionNotProblemsAddendum(cade,3));
		IterationsVersusSTDVol(IterationsVersusSTDVolPointer,9) = std(InitionConditionNotProblemsAddendum(cade,3));
		IterationsVersusSTDVol(IterationsVersusSTDVolPointer,10) = mean(InitionConditionNotProblemsAddendum(cade,4));
		IterationsVersusSTDVol(IterationsVersusSTDVolPointer,11) = std(InitionConditionNotProblemsAddendum(cade,4));
		IterationsVersusSTDVol(IterationsVersusSTDVolPointer,12) = ...
            IterationsVersusSTDVol(IterationsVersusSTDVolPointer,7) * ...
            IterationsVersusSTDVol(IterationsVersusSTDVolPointer,9) * ...
            IterationsVersusSTDVol(IterationsVersusSTDVolPointer,11);    
		IterationsVersusSTDVol(IterationsVersusSTDVolPointer,13) = mean(hist(InitionConditionNotProblemsAddendum(cade,2),[LimHistXInf : BinHistX : LimHistXSup]));
		IterationsVersusSTDVol(IterationsVersusSTDVolPointer,14) = min(hist(InitionConditionNotProblemsAddendum(cade,2),[LimHistXInf : BinHistX : LimHistXSup]));
		IterationsVersusSTDVol(IterationsVersusSTDVolPointer,15) = max(hist(InitionConditionNotProblemsAddendum(cade,2),[LimHistXInf : BinHistX : LimHistXSup]));
		IterationsVersusSTDVol(IterationsVersusSTDVolPointer,16) = mean(hist(InitionConditionNotProblemsAddendum(cade,3),[LimHistYInf : BinHistY : LimHistYSup]));
		IterationsVersusSTDVol(IterationsVersusSTDVolPointer,17) = min(hist(InitionConditionNotProblemsAddendum(cade,3),[LimHistYInf : BinHistY : LimHistYSup]));
		IterationsVersusSTDVol(IterationsVersusSTDVolPointer,18) = max(hist(InitionConditionNotProblemsAddendum(cade,3),[LimHistYInf : BinHistY : LimHistYSup]));
		IterationsVersusSTDVol(IterationsVersusSTDVolPointer,19) = mean(hist(InitionConditionNotProblemsAddendum(cade,4),[LimHistZInf : BinHistZ : LimHistZSup]));
		IterationsVersusSTDVol(IterationsVersusSTDVolPointer,20) = min(hist(InitionConditionNotProblemsAddendum(cade,4),[LimHistZInf : BinHistZ : LimHistZSup]));
		IterationsVersusSTDVol(IterationsVersusSTDVolPointer,21) = max(hist(InitionConditionNotProblemsAddendum(cade,4),[LimHistZInf : BinHistZ : LimHistZSup]));
		IterationsVersusSTDVol(IterationsVersusSTDVolPointer,22) = ...
            (IterationsVersusSTDVol(IterationsVersusSTDVolPointer,14)/IterationsVersusSTDVol(IterationsVersusSTDVolPointer,13)) * ...
            (IterationsVersusSTDVol(IterationsVersusSTDVolPointer,17)/IterationsVersusSTDVol(IterationsVersusSTDVolPointer,16)) * ...
            (IterationsVersusSTDVol(IterationsVersusSTDVolPointer,20)/IterationsVersusSTDVol(IterationsVersusSTDVolPointer,19));
		IterationsVersusSTDVolPointer = IterationsVersusSTDVolPointer + 1;
        
    end % for stoptime = StopTime;
end % for DiscretisationCriteria = discretisation

% Now that we finished simulating all Initial Condictions and StopTimes, we can save the table of GOOD and BAD ICs
if IterationsVersusSTDVol(1,1) ~= 987654321
	eval(['IterationsVersusSTDVol_', DATESTR(datenum(TimeStart),30), ' = IterationsVersusSTDVol;']);
	filename = (['', DATESTR(datenum(TimeStart),30), '_IterationsVersusSTDVol.mat']);
	eval(['save(filename,''IterationsVersusSTDVol_', DATESTR(datenum(TimeStart),30), '*'')']);
end

for DiscretisationCriteria = discretisation
    procurar = find(IterationsVersusSTDVol(:,2) == DiscretisationCriteria);
    figure(9)
%     plot( log10(IterationsVersusSTDVol(procurar,1)) , IterationsVersusSTDVol(procurar,3) ,'k'); grid on; hold on;
%     plot( (IterationsVersusSTDVol(procurar,1)) , IterationsVersusSTDVol(procurar,12) ,'b'); grid on; hold on;
    plot( (IterationsVersusSTDVol(procurar,1)) , IterationsVersusSTDVol(procurar,22) ,'c'); grid on; hold on;
    plot( (IterationsVersusSTDVol(procurar,1)) , IterationsVersusSTDVol(procurar,22) ,'c.'); grid on; hold on;
    title(['Dispersion Evolution for: Iteration = (', num2str(min(StopTime)), ':', num2str(max(StopTime)) '), Exponent = ', num2str(-log2(DiscretisationCriteria)), ' (', num2str(min(Exponent)), ':', num2str(max(Exponent)), ')']);
	xlabel(['Number of Iterations in Linear Scale. Xo = ', num2str(XZeroStart), ' : ', num2str(-log2(XZeroStep)), ' : ', num2str(XZeroEnd),  ' , Yo = ', num2str(YZeroStart), ' : ', num2str(-log2(YZeroStep)), ' : ', num2str(YZeroEnd), ' , Zo = ', num2str(ZZeroStart), ' : ', num2str(-log2(ZZeroStep)), ' : ', num2str(ZZeroEnd),')']);
	ylabel(['Standart deviation Volume']);
    % Now we are going to save the produced grafic in 2 different formats
	eval(['cd ', DATESTR(datenum(TimeStart),30), '_Figures']);
	filename = ([DATESTR(datenum(now),30), '_Dispersion_', num2str(-log2(DiscretisationCriteria)), '_EXP_', num2str(stoptime), '_StopTime', '.fig']);
	saveas(9, filename, 'fig');
    pause(1)
	filename = ([DATESTR(datenum(now),30), '_Dispersion_', num2str(-log2(DiscretisationCriteria)), '_EXP_', num2str(stoptime), '_StopTime', '.jpg']);
	saveas(9, filename, 'jpg');
	cd ..
	close(9);
end % for DiscretisationCriteria = discretisation

% Now it plays a sound that indicates the end of the simulation
[SimEnd,FqSp,NBits]=wavread('EndOfSimulation.wav');
soundsc(SimEnd,FqSp)
fprintf('\n')

% Now it saves and prints the End of Simulation Time
EndOfSimulation = datestr(now);
fprintf('The simulations Starts on %s\n', datestr(TimeStart));
fprintf('The simulations Ends on %s\n', datestr(EndOfSimulation));
fprintf('\n')
